#include <p30fxxxx.h>
#include <timer.h>

/* These devices support Timer 5 */
#if defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || defined(__dsPIC30F3011__)  || \
    defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || \
    defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F4013__) || \
    defined(__dsPIC30F5015__)

/********************************************************************
*    Function Name:  OpenTimer5                                     *
*    Description:    This routine configures the timer control regis*
*                    ter and timer period register.                 *
*    Parameters:     config: bit definitions to configure Timer5    *
*                    period: value to be loaded to PR reg           *
*    Return Value:   None                                           *
********************************************************************/

void OpenTimer5(unsigned int  config,unsigned int period)
{
    TMR5  = 0;          /* Reset Timer5 to 0x0000 */
    PR5   = period;     /* Assigning Period to Timer period register.*/
    T5CON =  config;    /* configure timer control reg */
}

#endif 
